package cologne.eck.all_peas.gui;


import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

import cologne.eck.all_peas.data.PeaProperties;
import cologne.eck.all_peas.vm_specific.JREProperties;

@SuppressWarnings("serial")
public class GuideCloud extends JDialog implements ActionListener {
	
	//private boolean okButtonPressed = false;
	
	
	/**
	 * Shows a manual for the PEA
	 */
	public GuideCloud() {

		super(JREProperties.getMainWindow());
		this.setModalityType(JDialog.ModalityType.APPLICATION_MODAL);
		
		//okButtonPressed = false;

		// Avoid keyboard trap: Close with ESC
		this.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW)
    		.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "CLOSE_ON_ESCAPE");
		this.getRootPane().getActionMap().put("CLOSE_ON_ESCAPE", new CloseOnEscapeAction() );
			
		JPanel contentPane = (JPanel) this.getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));
		
//		int[] colorValues = PeaProperties.getCipherPeaColor();
//		Color background = new Color(colorValues[0], colorValues[1], colorValues[2]);
		
		JPanel headingPanel = new JPanel();
		headingPanel.setLayout(new BoxLayout(headingPanel, BoxLayout.LINE_AXIS));
		String heading = PeaProperties.getVmBridge().translate("notes_on_usage");
		
		JLabel headingLabel = new JLabel(heading + " - " + PeaProperties.getVmBridge().translate("cloud"));
		headingLabel.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 24));
		headingPanel.add(headingLabel);
		contentPane.add(headingPanel);
		contentPane.add(Box.createVerticalStrut(20));
		
		JTextArea infoPane = new JTextArea(11, 45);
		//infoPane.setBackground(background);
		infoPane.setEditable(false);
		infoPane.setLineWrap(true);
		infoPane.setWrapStyleWord(true);
		infoPane.setText( // TODO
				PeaProperties.getVmBridge().translate("cloud_info_1")
				//"An existing account with a cloud provider that supports WebDAV is required."
				+ "\n"
				+ PeaProperties.getVmBridge().translate("cloud_info_2")
				//+ "Search the Internet or take a look at the cloud providers that are listed in the following Add dialog."
				+ "\n\n\n"
				+ PeaProperties.getVmBridge().translate("cloud_info_3")
				//+ "A directory named PeaFactory is created in the cloud and only this directory is accessed."
				+ "\n"			
				+ PeaProperties.getVmBridge().translate("cloud_info_4")
				//+ "The passwords for the cloud providers are encrypted with the main password and then stored."
				+ "\n"	
				+ PeaProperties.getVmBridge().translate("cloud_info_5")
				//+ "It is better to add a new cloud provider after entering the password."	
				+ "\n"
				);
		contentPane.add(infoPane);
		contentPane.add(Box.createVerticalStrut(20));		
		
		JPanel okPanel = new JPanel();
		okPanel.setLayout(new BoxLayout(okPanel, BoxLayout.LINE_AXIS));
	    JButton okButton = new JButton(PeaProperties.getVmBridge().translate("ok"));
	    okButton.setMinimumSize(new Dimension(300, 50));
	    okButton.setMaximumSize(new Dimension(300, 50));
	    okButton.addActionListener(this);
	    okButton.setActionCommand("hideDialog");
	    okButton.getAccessibleContext().
	    setAccessibleDescription(
	    	    "Clicking this component closes this info dialog.");
	    okPanel.add(okButton);
	    contentPane.add(okPanel);	    
	    
	    this.setLocation(JREProperties.getMainWindow().getLocationOnScreen());
	    this.pack();

	    okButton.requestFocus();
	    okButton.requestFocusInWindow();
	}

	@Override
	public void actionPerformed(ActionEvent ae) {

		if (ae.getActionCommand().equals("hideDialog")) {
			//okButtonPressed = true;
			this.setVisible(false);
			this.dispose();
		}		
	}
/*	public boolean isOkButtonPressed() {
		return okButtonPressed;
	}*/
}
