package cologne.eck.all_peas.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

import cologne.eck.all_peas.control.PeaControl;
import cologne.eck.all_peas.data.PeaProperties;
import cologne.eck.all_peas.vm_specific.JREProperties;

@SuppressWarnings("serial")
public class GuideUsage extends JDialog implements ActionListener {
	
	//private boolean okButtonPressed = false;
	
	
	/**
	 * Shows a manual for the PEA
	 */
	public GuideUsage() {

		super(JREProperties.getMainWindow());
		this.setModalityType(JDialog.ModalityType.APPLICATION_MODAL);
		
		//okButtonPressed = false;

		// Avoid keyboard trap: Close with ESC
		this.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW)
    		.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "CLOSE_ON_ESCAPE");
		this.getRootPane().getActionMap().put("CLOSE_ON_ESCAPE", new CloseOnEscapeAction() );
		
		
		JPanel contentPane = (JPanel) this.getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));
		
		int[] colorValues = PeaProperties.getCipherPeaColor();
		Color background = new Color(colorValues[0], colorValues[1], colorValues[2]);
		
		JPanel headingPanel = new JPanel();
		headingPanel.setLayout(new BoxLayout(headingPanel, BoxLayout.LINE_AXIS));
		String heading = PeaProperties.getVmBridge().translate("notes_on_usage");
		String fileInfo = PeaControl.getDialog().translatePeaSpecific("file_info");
		String noFile = PeaProperties.getVmBridge().translate("have_no_encrypted_file");
		String fileExists = PeaProperties.getVmBridge().translate("have_already_file");
		
		JLabel headingLabel = new JLabel(heading);
		headingLabel.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 24));
		headingPanel.add(headingLabel);
		contentPane.add(headingPanel);
		contentPane.add(Box.createVerticalStrut(20));
		
		JTextArea infoPane = new JTextArea(1, 45);
		infoPane.setBackground(background);
		infoPane.setEditable(false);
		infoPane.setLineWrap(true);
		infoPane.setWrapStyleWord(true);
		infoPane.setText( fileInfo 	);
		contentPane.add(infoPane);
		contentPane.add(Box.createVerticalStrut(20));
		
		
		JPanel noFilePanel = new JPanel();
		noFilePanel.setLayout(new BoxLayout(noFilePanel, BoxLayout.LINE_AXIS));
		JLabel noFileLabel = new JLabel(noFile);
		noFileLabel.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 16));
		noFilePanel.add(noFileLabel);
		contentPane.add(noFilePanel);
		//contentPane.add(Box.createVerticalStrut(5));
		
		JTextArea noFilePane = new JTextArea(3, 45);
		noFilePane.setEditable(false);
		noFilePane.setLineWrap(true);
		noFilePane.setWrapStyleWord(true);
		noFilePane.setText( 
				PeaProperties.getVmBridge().translate("menu") + " -> " +
				PeaProperties.getVmBridge().translate("file") + " -> " + 
				PeaProperties.getVmBridge().translate("init_new_file") + "\n-> " + 
				PeaProperties.getVmBridge().translate("enter_password") + " -> " + 
				PeaProperties.getVmBridge().translate("open_directory") + "\n-> " + 
				PeaProperties.getVmBridge().translate("choose_file_name")
				);
		contentPane.add(noFilePane);
		contentPane.add(Box.createVerticalStrut(20));
		
		
		JPanel fileExistsPanel = new JPanel();
		fileExistsPanel.setLayout(new BoxLayout(fileExistsPanel, BoxLayout.LINE_AXIS));
		JLabel fileExistsLabel = new JLabel(fileExists);
		fileExistsLabel.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 16));
		fileExistsPanel.add(fileExistsLabel);
		contentPane.add(fileExistsPanel);
		//contentPane.add(Box.createVerticalStrut(5));
		
		JTextArea fileExistsPane = new JTextArea(5, 45);
		fileExistsPane.setEditable(false);
		fileExistsPane.setLineWrap(true);
		fileExistsPane.setWrapStyleWord(true);
		fileExistsPane.setText( 
				PeaProperties.getVmBridge().translate("local_file") +"\n   " +
				PeaProperties.getVmBridge().translate("menu") + " -> " +
				PeaProperties.getVmBridge().translate("file") + " -> " + 
				PeaProperties.getVmBridge().translate("open_encrypted_file") + "\n\n" + 
				PeaProperties.getVmBridge().translate("cloud") + "\n  " + 
				PeaProperties.getVmBridge().translate("menu") + " -> " + 
				PeaProperties.getVmBridge().translate("cloud") + " -> " + 
				PeaProperties.getVmBridge().translate("add_cloud_provider") + "\n   " + 
				PeaProperties.getVmBridge().translate("download_from_cloud") 
				);
		contentPane.add(fileExistsPane);
		contentPane.add(Box.createVerticalStrut(30));

		JTextArea instructPane = new JTextArea(5, 50);
		instructPane.setBackground(background);
		instructPane.setEditable(false);
		instructPane.setLineWrap(true);
		instructPane.setWrapStyleWord(true);
		instructPane.setText( 		
			PeaControl.getDialog().translatePeaSpecific("instr_p_1")
				+ "\n" + PeaControl.getDialog().translatePeaSpecific("instr_p_2")
				+ "\n" + PeaControl.getDialog().translatePeaSpecific("instr_p_3")
				);
		contentPane.add(instructPane);
		contentPane.add(Box.createVerticalStrut(20));
	    
		JPanel okPanel = new JPanel();
		okPanel.setLayout(new BoxLayout(okPanel, BoxLayout.LINE_AXIS));
	    JButton okButton = new JButton(PeaProperties.getVmBridge().translate("ok"));
	    okButton.setMinimumSize(new Dimension(300, 50));
	    okButton.setMaximumSize(new Dimension(300, 50));
	    okButton.addActionListener(this);
	    okButton.setActionCommand("hideDialog");
	    okButton.getAccessibleContext().
	    setAccessibleDescription(
	    	    "Clicking this component closes this info dialog.");
	    okPanel.add(okButton);
	    contentPane.add(okPanel);
	    
	    
	    this.setLocation(JREProperties.getMainWindow().getLocationOnScreen());
	    this.pack();

	    okButton.requestFocus();
	    okButton.requestFocusInWindow();
	}

	@Override
	public void actionPerformed(ActionEvent ae) {

		if (ae.getActionCommand().equals("hideDialog")) {
			//okButtonPressed = true;
			this.setVisible(false);
			this.dispose();
		}		
	}
/*	public boolean isOkButtonPressed() {
		return okButtonPressed;
	}*/
}
