package cologne.eck.all_peas.gui;


import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
//import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

import cologne.eck.all_peas.control.PeaControl;
import cologne.eck.all_peas.data.PeaProperties;
import cologne.eck.all_peas.vm_specific.JREProperties;

@SuppressWarnings("serial")
public class InitHelperDialog extends JDialog implements ActionListener {
	
	public InitHelperDialog(Window owner, String extraInfoText) {
		super(owner);
		if (owner == null) {
			owner = JREProperties.getMainWindow();
		}
		this.setModalityType(JDialog.ModalityType.MODELESS);  //APPLICATION_MODAL);
		
		// Avoid keyboard trap: Close with ESC
		this.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW)
    		.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "CLOSE_ON_ESCAPE");
		this.getRootPane().getActionMap().put("CLOSE_ON_ESCAPE", new CloseOnEscapeAction() );
		
		
		JPanel contentPane = (JPanel) this.getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));
		contentPane.setBorder(new EmptyBorder(5,5,5,5));
		
		JPanel infoPanel = new JPanel();
		infoPanel.setLayout(new BoxLayout(infoPanel, BoxLayout.LINE_AXIS));
		JLabel infoLabel = new JLabel(PeaControl.getDialog().translatePeaSpecific("file_info")); 
		//infoLabel.setFont(new Font(Font.SANS_SERIF, Font.BOLD, PeaProperties.getFontSize() + 2));
		//infoPanel.add(Box.createHorizontalStrut(20));
		infoPanel.add(infoLabel);
		infoPanel.add(Box.createHorizontalGlue());
		contentPane.add(infoPanel);		
		if (extraInfoText != null) {
			JPanel infoPanel2 = new JPanel();
			infoPanel2.setLayout(new BoxLayout(infoPanel2, BoxLayout.LINE_AXIS));
			JLabel infoLabel2 = new JLabel(extraInfoText); 
			//infoPanel2.add(Box.createHorizontalStrut(20));
			infoPanel2.add(infoLabel2);
			infoPanel2.add(Box.createHorizontalGlue());
			contentPane.add(infoPanel2);
		}
		contentPane.add(Box.createVerticalStrut(20));
	
		JPanel initPanel = new JPanel();
		initPanel.setLayout(new BoxLayout(initPanel, BoxLayout.LINE_AXIS));
		JLabel initLabel = new JLabel();
		initLabel.setText(PeaProperties.getVmBridge().translate("have_no_encrypted_file"));
		initPanel.add(initLabel);
		initPanel.add(Box.createHorizontalGlue());
		JButton initButton = new JButton(PeaProperties.getVmBridge().translate("init_new_file"));
		initButton.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, PeaProperties.getFontSize() + 2));
		initButton.setBorder(PeaBorderFactory.getButtonBorder());
		initButton.setMargin(new Insets(15,15,15,15));
		initButton.addActionListener(this);
		initButton.setActionCommand("init");
		initPanel.add(initButton);
		contentPane.add(initPanel);
		contentPane.add(Box.createVerticalStrut(20));
		
		JPanel openPanel = new JPanel();
		openPanel.setLayout(new BoxLayout(openPanel, BoxLayout.LINE_AXIS));
		JLabel openLabel = new JLabel();
		openLabel.setText(PeaProperties.getVmBridge().translate("have_already_file"));
		openPanel.add(openLabel);
		openPanel.add(Box.createHorizontalStrut(10));
		openPanel.add(Box.createHorizontalGlue());
		JButton openButton = new JButton(PeaProperties.getVmBridge().translate("open_file"));
		openButton.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, PeaProperties.getFontSize() + 2));
		openButton.setBorder(PeaBorderFactory.getButtonBorder());
		openButton.addActionListener(this);
		openButton.setActionCommand("open");
		openPanel.add(openButton);
		contentPane.add(openPanel);
		contentPane.add(Box.createVerticalStrut(20));
		
		JPanel skipPanel = new JPanel();
		skipPanel.setLayout(new BoxLayout(skipPanel, BoxLayout.LINE_AXIS));
		JButton skipButton = new JButton(PeaProperties.getVmBridge().translate("skip"));
		skipButton.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, PeaProperties.getFontSize() - 2));
		skipButton.setBorder(PeaBorderFactory.getButtonBorder());
		skipButton.addActionListener(this);
		skipButton.setActionCommand("skip");
		skipPanel.add(Box.createHorizontalGlue());
		skipPanel.add(skipButton);		
		contentPane.add(skipPanel);
			
		this.pack();
		//this.setLocationRelativeTo(owner);
		this.setLocation(new Point((int) owner.getLocationOnScreen().getX() + 50, 
				(int) owner.getLocationOnScreen().getY() + 50));
	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		String command = ae.getActionCommand();
		if (command.equals("skip")) {
			this.dispose();
		} else if (command.equals("init")) {
			this.dispose();
			PswDialogView.initialize();
		} else if (command.equals("open")) {
			this.dispose();
			PeaControl.getDialog().openEncryptedFiles();
		}

	}

	/*public static void main(String[] args) {
		JFrame f = new JFrame();
		f.setVisible(true);
		new InitHelperDialog(f, null, null).setVisible(true);
	}*/
}
