package cologne.eck.all_peas.gui;


import cologne.eck.all_peas.data.PeaProperties;
import cologne.eck.all_peas.util.TimeoutTimer;
import cologne.eck.tools.PropertyHandler;
import cologne.eck.tools.TestLog;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.time.Duration;


@SuppressWarnings("serial")
public class TimeoutSetter extends JDialog implements ChangeListener, ActionListener {
	
	private static TimeoutSetter timeoutSetter = null;
	
//	private static volatile Timer timer = null;
	private static volatile Duration lastDuration = Duration.ZERO;
	
	//private static int timeout = 0;
	private static Duration seconds = Duration.ZERO;
	private static Duration minutes = Duration.ZERO;
	private static Duration hours = Duration.ZERO;
	
	private JSlider secondsSlider = null;
	private JSlider minutesSlider = null;
	private JSlider hoursSlider = null;
	
	private JCheckBox alwaysCheck = null;
	
	private JLabel showTimeout = null;
	
	private static volatile PeaLockFrame lockFrame = null;
	
	/**
	 * Open a dialog to set 
	 * @param owner
	 */
	private TimeoutSetter(PeaLockFrame _lockFrame) {
		
		TimeoutSetter.timeoutSetter = this;
		
		TimeoutSetter.lockFrame = _lockFrame;

		this.setIconImages(IconManager.getIconList());
		this.setTitle(PeaProperties.getVmBridge().translate("timer"));
		
		String autoTimeout = PeaProperties.getTimeout();
		//TestLog.v(getClass(), "timeout: "+ autoTimeout);
		if (autoTimeout != null && autoTimeout.length() > 0) {
			TestLog.v(getClass(), "timeout: "  + autoTimeout);
			long sec = Long.parseLong(autoTimeout);
			lastDuration = Duration.ofSeconds(sec);
			seconds = Duration.ofSeconds(lastDuration.getSeconds() % 60);
			minutes = Duration.ofMinutes((lastDuration.getSeconds() / 60) % 60);
			hours = Duration.ofHours((lastDuration.getSeconds() / 3600) % 24); 
			TestLog.e(getClass(), "seconds: " + seconds + ", min: "+ minutes + ", h: " + hours );
	/*		seconds = Duration.ofSeconds(lastDuration.getSeconds() % 60);
			minutes = Duration.ofSeconds((lastDuration.getSeconds() % 3600) / 60);
			hours = Duration.ofSeconds(lastDuration.getSeconds() / 3600); 
			TestLog.e(getClass(), "seconds: " + seconds + ", min: "+ minutes + ", h: " + hours );
			seconds = Duration.ofSeconds(lastDuration.getSeconds() % 60);
			minutes = Duration.ofMinutes(lastDuration.toMinutes());
			hours = Duration.ofHours(lastDuration.toHours()); 
			TestLog.e(getClass(), "seconds: " + seconds + ", min: "+ minutes + ", h: " + hours );*/
		}
		

		JPanel contentPane = (JPanel) this.getContentPane();//new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.PAGE_AXIS));
		contentPane.setBorder(PeaBorderFactory.createBorder(false));
		
		// avoid keyboard trap: close with escape
		this.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW)
        	.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "CLOSE_ON_ESCAPE");
		this.getRootPane().getActionMap().put("CLOSE_ON_ESCAPE", new CloseOnEscapeAction() );
		
		JPanel infoPanel = new JPanel();
		infoPanel.setLayout(new BoxLayout(infoPanel, BoxLayout.LINE_AXIS));
		JLabel infoLabel = new JLabel(PeaProperties.getVmBridge().translate("timer_tooltip"));
		infoPanel.add(Box.createHorizontalStrut(10));
		infoPanel.add(infoLabel);
		infoPanel.add(Box.createHorizontalGlue());
		contentPane.add(infoPanel);
		
		contentPane.add(Box.createVerticalStrut(20));
		
		int s_MIN = 0;
		int s_MAX = 59;
		int s_INIT = (int) (lastDuration.getSeconds() % 60);    //initial frames per second
		secondsSlider = new JSlider(JSlider.HORIZONTAL,
		                                      s_MIN, s_MAX, s_INIT);
		secondsSlider.setMajorTickSpacing(10);
		secondsSlider.setMinorTickSpacing(1);
		secondsSlider.setPaintTicks(true);
		secondsSlider.setPaintLabels(true);
	//	secondsSlider.setValue(sec);
		secondsSlider.addChangeListener(this);
		JLabel secondsLabel = new JLabel(PeaProperties.getVmBridge().translate("seconds") + ": ");
		secondsLabel.setLabelFor(secondsSlider);
		contentPane.add(secondsLabel);
		contentPane.add(secondsSlider);
		contentPane.add(Box.createVerticalStrut(10));
		
		int m_MIN = 0;
		int m_MAX = 59;
		int m_INIT = (int) (lastDuration.getSeconds() / 60) % 60;//((lastDuration.getSeconds() % 3600) / 60);    //initial frames per second
		minutesSlider = new JSlider(JSlider.HORIZONTAL,
		                                      m_MIN, m_MAX, m_INIT);
		minutesSlider.setMajorTickSpacing(10);
		minutesSlider.setMinorTickSpacing(1);
		minutesSlider.setPaintTicks(true);
		minutesSlider.setPaintLabels(true);
	//	minutesSlider.setValue(min);
		minutesSlider.addChangeListener(this);
		JLabel minutesLabel = new JLabel(PeaProperties.getVmBridge().translate("minutes") + ": ");
		minutesLabel.setLabelFor(minutesSlider);
		contentPane.add(minutesLabel);
		contentPane.add(minutesSlider);
		contentPane.add(Box.createVerticalStrut(10));
		
		int h_MIN = 0;
		int h_MAX = 23;
		int h_INIT = (int) (lastDuration.getSeconds() / 3600) % 24;// (lastDuration.getSeconds() / 3600);    //initial frames per second
		hoursSlider = new JSlider(JSlider.HORIZONTAL,
		                                      h_MIN, h_MAX, h_INIT);
		hoursSlider.setMajorTickSpacing(10);
		hoursSlider.setMinorTickSpacing(1);
		hoursSlider.setPaintTicks(true);
		hoursSlider.setPaintLabels(true);
	//	hoursSlider.setValue(hours);
		hoursSlider.addChangeListener(this);
		JLabel hoursLabel = new JLabel(PeaProperties.getVmBridge().translate("hours") + ": ");
		hoursLabel.setLabelFor(hoursSlider);
		contentPane.add(hoursLabel);
		contentPane.add(hoursSlider);
		contentPane.add(Box.createVerticalStrut(20));
		
		JPanel showTimeoutPanel = new JPanel();
		showTimeoutPanel.setLayout(new BoxLayout(showTimeoutPanel, BoxLayout.LINE_AXIS));
		JLabel setLabel = new JLabel(PeaProperties.getVmBridge().translate("exit_program_in"));
		setLabel.setLabelFor(showTimeout);
		showTimeoutPanel.add(setLabel);
		showTimeoutPanel.add(Box.createHorizontalStrut(10));
		showTimeout = new JLabel(getTimeoutAsString(lastDuration));
		showTimeoutPanel.add(showTimeout);
		contentPane.add(showTimeoutPanel);
		contentPane.add(Box.createVerticalStrut(5));
		
		JPanel checkPanel = new JPanel();
		checkPanel.setLayout(new BoxLayout(checkPanel, BoxLayout.LINE_AXIS));
		alwaysCheck = new JCheckBox(PeaProperties.getVmBridge().translate("timeout_auto"));
		//alwaysCheck = new JCheckBox("Always close the program after this period of time."); 
		if (PeaProperties.getTimeout() != null && PeaProperties.getTimeout().length() > 0) {
			alwaysCheck.setSelected(true); 
		} else {
			alwaysCheck.setSelected(false);
		}
		//alwaysCheck.addChangeListener(this);
		checkPanel.add(alwaysCheck);
		contentPane.add(checkPanel);
		contentPane.add(Box.createVerticalStrut(5));
		
		JButton okButton = new JButton(PeaProperties.getVmBridge().translate("ok"));
		okButton.addActionListener(this);
		contentPane.add(okButton);
		
		this.pack();		
		this.setLocationRelativeTo(lockFrame);//.setLocation(MainView.getFrameLocation());
		//this.setVisible(true);
	}
	
	public static TimeoutSetter getInstance(PeaLockFrame _lockFrame) {
		
		if (timeoutSetter != null) {
			TimeoutSetter.timeoutSetter.setVisible(true);
			return TimeoutSetter.timeoutSetter;
		}		
		if (_lockFrame == null) {
			TestLog.ve(TimeoutSetter.class, "Missing lockFrame", 5);
			return null;
		}
		return new TimeoutSetter(_lockFrame);
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		if (e.getSource() instanceof JSlider) {

			JSlider source = (JSlider)e.getSource();
			if (source == secondsSlider) {
				if (!source.getValueIsAdjusting()) {
					int s = (int)source.getValue();
					seconds = Duration.ofSeconds(s);
					showTimeout.setText(getTimeoutAsString(getTimeoutDuration()));
				}
			} else if (source == minutesSlider) {
				if (!source.getValueIsAdjusting()) {
					int s = (int)source.getValue();
					minutes = Duration.ofMinutes(s);
					showTimeout.setText(getTimeoutAsString(getTimeoutDuration()));
				}
			} else if (source == hoursSlider) {
				if (!source.getValueIsAdjusting()) {
					int s = (int)source.getValue();
					hours = Duration.ofHours(s);
					showTimeout.setText(getTimeoutAsString(getTimeoutDuration()));
				}
			} 
		} 		
	}
	public static String getTimeoutAsString(Duration d) {
		//Duration d = getTimeoutDuration();
		long t = d.getSeconds();	
		//return String.format("%d:%02d:%02d", t / 3600, (t % 3600) / 60, (t % 60));
		return String.format("%d:%02d:%02d", (t / 3600) % 24, (t / 60 ) % 60, (t % 60));
		
		//return String.format("%2d:%02d:%02d", hours.getSeconds() / 3600, minutes.getSeconds() / 60, seconds.getSeconds());
	}



	
	private static Duration getTimeoutDuration() {
		Duration d = Duration.ZERO;
		d = d.plus(seconds).plus(minutes).plus(hours);
		return d;
	}

	@Override
	public synchronized void actionPerformed(ActionEvent e) {
		if (e.getSource() instanceof JButton) {
			lastDuration = TimeoutSetter.getTimeoutDuration();
			TimeoutTimer.startInstance(lastDuration, lockFrame);
			if (alwaysCheck.isSelected()) {
				// store time in properties 
				PeaProperties.setTimeout("" + lastDuration.getSeconds());
				new PropertyHandler().setOneProperty("timeout", "" + lastDuration.getSeconds());
			} else {
				PeaProperties.setTimeout("");
			}
			this.dispose();
		} 
	}
	
	/**
	 * Set the lockFrame for TimeoutSetter.
	 * Used, when lockFrame was rest. 
	 * 
	 * @param _lockFrame	the current PeaLockFrame
	 */
	public static void setLockFrame(PeaLockFrame _lockFrame) {
		TimeoutSetter.lockFrame = _lockFrame;
	}
}
