package cologne.eck.all_peas.gui.menu;

import java.awt.Color;
import java.awt.Component;

/*
 * Peafactory - Production of Password Encryption Archives
 * Copyright (C) 2020  Axel von dem Bruch
 * 
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details.
 * See:  http://www.gnu.org/licenses/gpl-2.0.html
 * You should have received a copy of the GNU General Public License 
 * along with this library.
 */

/**
 * Settings for the password hashing scheme Pomelo. 
 */

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import cologne.eck.all_peas.cloud.CloudControl;
import cologne.eck.all_peas.cloud.CloudPropertyHandler;
import cologne.eck.all_peas.cloud.StorageProvider;
import cologne.eck.all_peas.cloud.gui.CloudFileManager;
import cologne.eck.all_peas.cloud.gui.WebDavLogin;
import cologne.eck.all_peas.cloud.provider.WebDavProvider;
import cologne.eck.all_peas.control.PeaControl;
import cologne.eck.all_peas.data.AttachmentHandler;
import cologne.eck.all_peas.data.PeaProperties;
import cologne.eck.all_peas.files.CloudFilePanel;
import cologne.eck.all_peas.files.FilePanelHolder;
import cologne.eck.all_peas.files.FileTypePanel;
import cologne.eck.all_peas.gui.CursorManager;
import cologne.eck.all_peas.gui.IconManager;
import cologne.eck.all_peas.gui.PeaDialog;
import cologne.eck.all_peas.gui.PswDialogView;
import cologne.eck.all_peas.vm_specific.JREProperties;
import cologne.eck.peafactory.crypto.kdf.KeyDerivation;
import cologne.eck.tools.Comparator;
import cologne.eck.tools.Converter;
import cologne.eck.tools.TestLog;
import cologne.eck.tools.UnexpectedValueException;


/**
 * 
 * @author ax
 *
 * Display as selectable list of files from all cloud providers, 
 * that are shown in password dialog in CloudFilePanels.
 */
@SuppressWarnings("serial")
class XXXCloudFileSetting extends JDialog implements ActionListener {
	
	private static XXXCloudFileSetting cloudFileSetting;
	
	private JPanel displayPanel;

	
	public XXXCloudFileSetting(Window parent, Point point) {

		super(parent);
		
		cloudFileSetting = this;
		//cloudFileSetting.setAlwaysOnTop(true);		
		
		this.setTitle(PeaProperties.getVmBridge().translate("path_file"));				
		this.setIconImages(IconManager.getIconList());
		
		JPanel pane = (JPanel) cloudFileSetting.getContentPane();//new JPanel();
		pane.setLayout(new BoxLayout(pane, BoxLayout.PAGE_AXIS));
		
		JLabel infoLabel = new JLabel();
		infoLabel.setText(PeaProperties.getVmBridge().translate("cloud_file_info"));
		infoLabel.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, PeaProperties.getFontSize()));
		pane.add(infoLabel);
		pane.add(Box.createVerticalStrut(10));
		
		displayPanel = new JPanel();
		displayPanel.setLayout(new BoxLayout(displayPanel, BoxLayout.PAGE_AXIS));
		JScrollPane scrollPane = new JScrollPane(displayPanel);
		scrollPane.setPreferredSize(new Dimension (350, 300));		
		pane.add(scrollPane);
		
		// set the display:
		String[] providerNames = CloudPropertyHandler.getProviderNames();
		LineBorder lineBorder = new LineBorder(Color.BLACK, 1);
		for (String providerName : providerNames) {
			JPanel providerPanel = new JPanel();
			providerPanel.setName(providerName);
			providerPanel.setLayout(new BoxLayout(providerPanel, BoxLayout.PAGE_AXIS));
			providerPanel.setBorder(new TitledBorder(lineBorder, 
					PeaProperties.getVmBridge().translate("cloud") + " : " + providerName));
// TODO test
	//		String[] filesFromProvider = CloudPropertyHandler.getAllFilesFromProvider(providerName);

	/*		for (String fileName : filesFromProvider) {
				if (fileName != null && fileName.length() > 0) {
					JCheckBox check = new JCheckBox();
					check.setText(providerName + ": " + fileName);
					check.setSelected(true);
					providerPanel.add(check);
				}
			}*/

			JButton button = new JButton(PeaProperties.getVmBridge().translate("add_new_file"));
			button.addActionListener(this);
			button.setActionCommand(providerName);
			providerPanel.add(button);
			displayPanel.add(providerPanel);
			displayPanel.add(Box.createHorizontalStrut(5));
		}
				
		JButton okButton = new JButton("ok");
		okButton.setActionCommand("newCloudSetting");
		okButton.addActionListener(this);
		pane.add(okButton);
		cloudFileSetting.pack();
		cloudFileSetting.setLocation(point);
		cloudFileSetting.setVisible(true);
	}
	


	@Override
	public void actionPerformed(ActionEvent ape) {

		String command = ape.getActionCommand();
		
		if (command != null && command.equals("newCloudSetting")) {
			
			// get all components of displayPanel:
			Component[] comps = displayPanel.getComponents();
			for (Component c : comps) {
				
				// get panel of one provider
				if (c instanceof JPanel) {					
					JPanel providerPanel = (JPanel) c;
					if (providerPanel.getName() != null) { // only providerPanels are named
						String providerName = providerPanel.getName();
						// get all components of this providerPanel
						Component[] providerComps = providerPanel.getComponents();
						if (providerComps != null) {
							// list of file names of this provider:
							ArrayList<String> fileNameList = new ArrayList<String>();
							for (Component providerC : providerComps) {
								if (providerC instanceof JCheckBox) {
									JCheckBox check = (JCheckBox) providerC;
									if (check.isSelected()) {
										String checkText = check.getText();
										String fileName = checkText.substring(
												checkText.indexOf(":") + 1, 
												checkText.length()).trim();
										if (fileName != null) {
											fileNameList.add(fileName);
										}
									}
								}
								
							}
							// set the new properties: 
							if (fileNameList.isEmpty() == false) {
								// create the String to set:
								StringBuilder fileNamesAsString = new StringBuilder();
								for (String f : fileNameList) {
									fileNamesAsString.append(f + ",");
								}
								// remove last comma:
								if (fileNamesAsString.length() > 0) {
									fileNamesAsString.setLength(fileNamesAsString.length() - 1);
								}
								TestLog.e(XXXCloudFileSetting.class, "Wrong implementation...");
								return;
				/*				CloudPropertyHandler.resetFileNames(providerName, 
										// TODO falsch!!!!!!!!!!!!!
										new String(fileNamesAsString), Converter.bytes2hex(KeyDerivation.getSalt()), Converter.bytes2hex(PeaProperties.getAlgoParamString()));*/
							} else {
								// no cloud file: 
								TestLog.o(XXXCloudFileSetting.class, "Remove all files from properties for " + providerName);
								//CloudPropertyHandler.setSingleProperty(providerName + "_files", "");
								// TODO test
								CloudPropertyHandler.resetFileNames(providerName, "", Converter.bytes2hex(KeyDerivation.getSalt()), Converter.bytes2hex(PeaProperties.getAlgoParamString()), null);		
							}
						}						
					}
				}
			}
			cloudFileSetting.dispose();
			
			if (JREProperties.getMainWindow() instanceof PswDialogView) {
				// update the view:
				FileTypePanel ftp = (FileTypePanel)JREProperties.getTypePanel();
				// reset the model:
			//	HashMap<String, HashSet<String>> map = CloudControl.createInitialCloudFileMap(
			//			Converter.bytes2hex(ftp.getSalt()), Converter.bytes2hex(ftp.getAlgoParamString()));
				CloudFilePanel cfp = new CloudFilePanel(JREProperties.getMainWindow(), ftp, //map, 
						Converter.bytes2hex(ftp.getSalt()), Converter.bytes2hex(ftp.getAlgoParamString()));
				ftp.setCloudFilePanel(cfp);
				ftp.getCloudFilePanel().updateView();
			}
			
		} else  {
			String providerName = command;
			if ( ((FileTypePanel)JREProperties.getTypePanel()).getCloudFilePanel().getCloudControl().getUsedProvidersAsSet().contains(providerName)
					|| Arrays.asList(CloudPropertyHandler.getProviderNames()).contains(providerName)) {

				if (providerName != null) {

					String[] params = CloudPropertyHandler.getProviderLoginParameters(providerName);
					StorageProvider prov = null;

					if (params[0] == null || params[2] == null) { // user name, WebDAV path - this should not happen...
						// show a login dialog without password
						WebDavLogin login = new WebDavLogin(
								JREProperties.getMainWindow(), 
								null,
								null, 
								providerName, 
								params[0], 
								null,
								null, 
								params[2]);
						int result = login.showLoginDialog();
						if (result == 0) {
							prov = login.getProvider();
							// TODO keep the password, save encrypted when key was derived...
							// must be done in WebDavLogin if root window name is "EncryptedDialog"
							login.dispose();
						}
					}
					// get the password: 
					char[] psw = null;
					if (JREProperties.getMainWindow().getName().equals("EncryptedDialog") ) {
						// check if password was inserted manually
						if (WebDavLogin.getPasswordsFromNewProviderDialog() != null) {
							byte[] pswBytes = WebDavLogin.getPasswordsFromNewProviderDialog().get(providerName);
							if (pswBytes != null) {
								psw = Converter.bytes2chars(pswBytes);
							} else {
								psw = PeaDialog.showPasswordDialog(this, providerName + ": " + PeaProperties.getVmBridge().translate("enter_cloud_password"), 
										PeaProperties.getVmBridge().translate("password"), false);
								if (Comparator.compare(psw, "cAnCeLlEd".toCharArray())) {
									TestLog.v(getClass(), "Process cancelled");
									return;
								}
							}
						} else { // ask for password
							psw = PeaDialog.showPasswordDialog(this, providerName + ": " + PeaProperties.getVmBridge().translate("enter_cloud_password"), 
									PeaProperties.getVmBridge().translate("password"), false);	
							if (Comparator.compare(psw, "cAnCeLlEd".toCharArray())) {
								TestLog.v(getClass(), "Process cancelled");
								return;
							}
						}

					} else { // lockFrame 
						if (WebDavLogin.getPasswordsFromNewProviderDialog() != null) {
							byte[] pswBytes = WebDavLogin.getPasswordsFromNewProviderDialog().get(providerName);
							if (pswBytes != null) {
								psw = Converter.bytes2chars(pswBytes);
							} else {
								psw = PeaDialog.showPasswordDialog(this, providerName + ": " + PeaProperties.getVmBridge().translate("enter_cloud_password"), 
										PeaProperties.getVmBridge().translate("password"), false);
								if (Comparator.compare(psw, "cAnCeLlEd".toCharArray())) {
									TestLog.v(getClass(), "Process cancelled");
									return;
								}
							}
						} else {
							psw = PeaDialog.showPasswordDialog(this, providerName + ": " + PeaProperties.getVmBridge().translate("enter_cloud_password"), 
									PeaProperties.getVmBridge().translate("password"), false);	
							if (Comparator.compare(psw, "cAnCeLlEd".toCharArray())) {
								TestLog.v(getClass(), "Process cancelled");
								return;
							}
						}
					}
					if (psw == null) {
						PeaDialog.showMessage(this, PeaProperties.getVmBridge().translate("password")
								+ " " + PeaProperties.getVmBridge().translate("missing"), 
								PeaProperties.getVmBridge().translate("error"), 0);
						return;
					}
					// set wait cursor:
					try {
						this.setCursor(CursorManager.getWaitCursor());

						StorageProvider sp = CloudControl.getOpenProvider(providerName);
						if (sp == null) {
							sp = new WebDavProvider(providerName);
						}
						if (sp instanceof WebDavProvider) {
							prov = (WebDavProvider) sp;
						}
						//prov = 	 new WebDavProvider(provider);
						( (WebDavProvider) prov).setWebDavBasePath(params[2]);
						byte[] plainPswBytes = Converter.chars2bytes(psw);
						String error = prov.authorize(params[0], psw, null);
						if (error == null) {
							WebDavLogin.storePassword(providerName, plainPswBytes);
							String[] fileNames = prov.getCloudFiles(PeaControl.getDialog().getSupportedExtensions());
							( (WebDavProvider) prov).setWebDavBasePath(params[2]);
							CloudFileManager cfm = new CloudFileManager(JREProperties.getMainWindow(), prov, fileNames);
							// reset cursor
							if (SwingUtilities.getWindowAncestor(this) != null) {
								SwingUtilities.getWindowAncestor(this).setCursor(CursorManager.getDefaultCursor());
							}
							cfm.setVisible(true);
							String[] selectedFileNames = cfm.getSelectedFileNames();
							if (selectedFileNames != null) {
								// do not add to properties, salt and scheme are unchecked!
		/*						String addError = CloudPropertyHandler.addFileNamesToProperties(providerName, selectedFileNames, // TODO test
										Converter.bytes2hex(KeyDerivation.getSalt()), Converter.bytes2hex(PeaProperties.getAlgoParamString()));
								if (addError != null) {
									PeaDialog.showMessage(JREProperties.getMainWindow(), addError, 
											PeaProperties.getVmBridge().translate("error"), 0);
								}*/

								// update CloudFileSetting:
								Point p = cloudFileSetting.getLocationOnScreen();
								cloudFileSetting.dispose();						
								cloudFileSetting = new XXXCloudFileSetting(JREProperties.getMainWindow(), p);
								cloudFileSetting.setVisible(true);

								// update password dialog view
								FileTypePanel ftp = (FileTypePanel)JREProperties.getTypePanel();
								CloudFilePanel cfp = ftp.getCloudFilePanel();
		
								if (cfp == null) {
									TestLog.e(XXXCloudFileSetting.class, "Unexpected error");
									TestLog.ve(XXXCloudFileSetting.class, "Missing CloudFilePanel", 5);
									return;
									/*cfp = new CloudFilePanel(JREProperties.getMainWindow(), ftp, 
											((FileTypePanel)JREProperties.getTypePanel()).getCloudFilePanel().getCloudControl().getCloudFileModel().getInitialCloudFileMap(), 
											Converter.bytes2hex(KeyDerivation.getSalt()), Converter.bytes2hex(PeaProperties.getAlgoParamString()));
									ftp.setCloudFilePanel(cfp);*/
								} 

							/*	for (int i = 0; i < selectedFileNames.length;i++) {
									((FileTypePanel)JREProperties.getTypePanel()).getCloudFilePanel().getCloudControl().addInitialFileToProvider(providerName, selectedFileNames[i], true);
								}*/
								if (JREProperties.getMainWindow() instanceof PswDialogView) {
							/*		cfp.getCloudControl().addDownloadedInitialFileNamesToProvider(providerName, selectedFileNames, false);

									cfp.updateView();
									ftp.updateFileView();*/
									int filesLen = selectedFileNames.length;
									String[] fileNamesWithPath = new String[filesLen];
									File[] files = new File[filesLen];
									for (int i = 0; i < filesLen; i++) {
										fileNamesWithPath[i] = CloudControl.getTmpFileNameForCloudFile(selectedFileNames[i], providerName, null);
										files[i] = new File(fileNamesWithPath[i]);
									}
									
									// register that these files are already downloaded:
									CloudControl.addDownloadedInitialFileNames(fileNamesWithPath);
									// distribute and add to panel:
									boolean fileAdded = AttachmentHandler.distributeFiles(files);
							    	if (fileAdded == true) {
							    		// update view:
							    		//FilePanelHolder.updateFileView();
							    		FilePanelHolder.updateWindow();
							    	}

								} else { // do not add to current view: this must be done with download
									/*	if (PeaControl.getDialog().getLockFrame() instanceof PeaLockFrame) {
									for (int i = 0; i < selectedFileNames.length;i++) {
										((PeaLockFrame)PeaControl.getDialog().getLockFrame())
										.decryptAndLoadFileToView(selectedFileNames[i]);
									}
								} */
								}
							}
						} else {
							this.setCursor(CursorManager.getDefaultCursor());

							PeaDialog.showMessage(this, PeaProperties.getVmBridge().translate("authorization_failed")
									+ "\n" + error, PeaProperties.getVmBridge().translate("error"), 0);
						}
					} finally {
						this.setCursor(CursorManager.getDefaultCursor());
					}
					
				}
			} else {
				new UnexpectedValueException("String", "providerName", "is not a valid provider: " +providerName).printDescription();
			}
		}
	}
/*	public static void main(String[] args){
		CloudFileSetting p = new CloudFileSetting(null, new Point(1200,100));
		p.setVisible(true);
	} */
	
}
