package cologne.eck.all_peas.util;

import java.io.File;

import cologne.eck.all_peas.data.PeaProperties;
import cologne.eck.tools.TestLog;

public class FileChecker {

	/**
	 * Checks if a file exists, is not a folder, write access, 
	 * is not empty, and not too large (> integer). Returns a translated 
	 * error message for first check that fails.
	 * 
	 * @param file	the name of the file to check
	 * 
	 * @return	null if no check failed, a translated error message otherwise
	 */
/*	public static String checkFile(String fileName) {
		return checkFile(new File(fileName), true);
	} */
	
	/**
	 * Checks if a file exists, is not a folder, write access, 
	 * is not empty, and not too large (> integer). Returns a translated 
	 * error message for first check that fails.
	 * 
	 * @param file	the file to check
	 * 
	 * @return	null if no check failed, a translated error message otherwise
	 */
	public static String checkFile(File file) {
		return checkFile(file, true);
	}
	
	/**
	 * Checks if a file exists, is not a folder, write access or read access, 
	 * is not empty, and not too large (> integer). Returns a translated 
	 * error message for first check that fails.
	 * 
	 * @param file	the file to check
	 * @param	checkWriteAccess	true: check write access, false: check read access
	 * 
	 * @return	null if no check failed, a translated error message otherwise
	 */
	public static String checkFile(File file, boolean checkWriteAccess) {
		
		if (file == null) {
			TestLog.ve(FileChecker.class, "Missing file (object is null)", 3);
			return PeaProperties.getVmBridge().translate("missing") + ": " 
					+ PeaProperties.getVmBridge().translate("file");
		}		
		if ( ! file.exists()) {
			TestLog.ve(FileChecker.class, "Does not exist" + " - " + file.getAbsolutePath(), 3);
			return PeaProperties.getVmBridge().translate("file_not_found");
		}
		if (file.isDirectory()) {
			TestLog.ve(FileChecker.class, "Is directory " + " - " + file.getAbsolutePath());
			return PeaProperties.getVmBridge().translate("is_a_directory");
		}
		if ( ! file.canWrite()) {
			TestLog.ve(FileChecker.class, "No write access" + " - " + file.getAbsolutePath());
			return PeaProperties.getVmBridge().translate("no_access");
		}
		long fileLen = file.length();
		if ( fileLen == 0) {
			TestLog.ve(FileChecker.class, "Empty file" + " - " + file.getAbsolutePath());
			return PeaProperties.getVmBridge().translate("empty_file");
		} else if (fileLen > Integer.MAX_VALUE) { // > int
			return PeaProperties.getVmBridge().translate("file_too_large");
		}
		return null;
	}
}
