package cologne.eck.all_peas.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import java.util.HashSet;

import javax.swing.Timer;

import cologne.eck.all_peas.control.PathFileManager;
import cologne.eck.all_peas.gui.PeaLockFrame;
import cologne.eck.all_peas.gui.TimeoutSetter;
import cologne.eck.file_pea.LockFrameFile;
import cologne.eck.tools.Converter;
import cologne.eck.tools.TestLog;

public class TimeoutTimer implements ActionListener {
	
	private static volatile TimeoutTimer tt = null;
	
	private static volatile Timer timer = null;
	private static volatile Duration lastDuration = Duration.ZERO;
	private static PeaLockFrame lockFrame = null;
	
	private TimeoutTimer (Duration _lastDuration, PeaLockFrame _lockFrame) {
		tt = this;
		lastDuration = _lastDuration;
		lockFrame = _lockFrame;
		
		int timerTimeInMilliSeconds = 5000;
		timer = new javax.swing.Timer(timerTimeInMilliSeconds, this);
		timer.start();
		LockFrameFile.setTimerStarted(true);
		String timeoutString = TimeoutSetter.getTimeoutAsString(lastDuration);
		lockFrame.setTimeoutTime(timeoutString);
		TestLog.v(TimeoutSetter.class, "Timeout: " + timeoutString);
	}

	/**
	 * Start the timer to close the program.
	 * 
	 * @param _lastDuration	amount of time, must be > 0
	 * @param _lff	must not be null
	 * 
	 * @return	the timer that closes the program after an amount of time
	 */
	public static TimeoutTimer startInstance(Duration _lastDuration, PeaLockFrame _lff) {
		if (_lastDuration.getSeconds() <= 0) {
			TestLog.ve(TimeoutTimer.class, "Invalid duration: " + _lastDuration);
			return null;
		}
		if (_lff == null) {
			TestLog.ve(TimeoutTimer.class, "Missing lockFrame" + _lastDuration, 5);
			return null;	
		}
		tt = new TimeoutTimer(_lastDuration, _lff);
		return tt;
	}
	
	/**
	 * Start the timer to close the program.
	 * 
	 * @param _lastDurationString 	amount of time as String, must be > 0
	 * @param _lff	must not be null
	 * 
	 * @return	the timer that closes the program after an amount of time
	 */
	public static TimeoutTimer startInstance(String _lastDurationString, PeaLockFrame _lff) {
		Duration _lastDuration = getDurationFromString(_lastDurationString);
		if (_lastDuration != null && _lff != null) {
			tt = new TimeoutTimer(_lastDuration, _lff);
			return tt;
		} else {
			TestLog.ve(TimeoutTimer.class, "Missing value", 5);
			return null;
		}
	}
	
	private static Duration getDurationFromString(String secondsAsString) {
		if (secondsAsString == null || secondsAsString.length() == 0) {
			TestLog.ve(TimeoutTimer.class, "Null value for timeout", 5);
			return null;
		}
		long t = 0;
		try {
			t = Long.parseLong(secondsAsString);
		} catch (NumberFormatException e) {
			TestLog.e(TimeoutTimer.class, e.getMessage(), 5);
			return null;
		}
		if (t <= 0) {
			TestLog.e(TimeoutTimer.class, "Invalid negative or null value for timeout: " + t, 5);
			return null;
		}
		return Duration.ofSeconds(t);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		
		lastDuration = lastDuration.minusSeconds(5);
		if (lastDuration.isNegative()) {
			// avoid asking to remember new files before closing:
			// always remember if program is closed by timeout:
			String[] currFileNames = lockFrame.getCurrentFileNames();
			if (currFileNames != null) {
				HashSet<String> availableSet = Converter.arrayToHashSet(currFileNames);
				PathFileManager.addFileNamesToPathFile(availableSet, false);
			}
			lockFrame.closeProgram();
		}			
		//TestLog.v(getClass(), lastDuration.toString());
		lockFrame.setTimeoutTime(TimeoutSetter.getTimeoutAsString(lastDuration));			
	}
}
