package cologne.eck.file_pea;

import cologne.eck.all_peas.control.Translator;
import cologne.eck.all_peas.data.PeaProperties;

/*
 * Peafactory - Production of Password Encryption Archives
 * Copyright (C) 2025  Axel von dem Bruch
 * 
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details.
 * See:  http://www.gnu.org/licenses/gpl-2.0.html
 * You should have received a copy of the GNU General Public License 
 * along with this library.
 */

public class FilePEASetting {
	
	/**
	 * The used Translator instance
	 */
	private static Translator translator = null;
	
	/*
	 * Show invalid files in panel on start when the last session 
	 * was not closed properly. These files may be left unencrypted
	 */
	private static boolean showInvalidPanel = false;
	
	/*
	 * Register if File Lock PEA was closed
	 * properly in the last session. 
	 */
	private static boolean closedProperly = true;
	
	/**
	 * Translate using the contact language bundle
	 * 
	 * @param key	the key to translate
	 * @return	the translated key or the key if no matching key is found
	 */
	public final static String fileTranslate(String key) {
		
		if (translator == null) {
			translator = PeaProperties.getVmBridge().getTranslator();		
		}
		return translator.translate(key, "file");
	}


	/**
	 * Check if the panel for invalid files should be shown
	 * 
	 * @return true: show invalid files
	 */
	public static boolean isShowInvalidPanel() {
		return showInvalidPanel;
	}

	/**
	 * Set if the panel for invalid files should be shown
	 * 
	 * @param showInvalidPanel	true: show invalid files
	 */
	public static void setShowInvalidPanel(boolean showInvalidPanel) {
		FilePEASetting.showInvalidPanel = showInvalidPanel;
	}

	/**
	 * Check if last session was closed properly or interrupted
	 * (unencrypted files left)
	 * 
	 * @return	true: last session was properly closed
	 */
	public static boolean isClosedProperly() {
		return closedProperly;
	}

	/**
	 * Set if last session was closed properly or interrupted
	 * (unencrypted files left)
	 * 
	 * @param closedProperly	true: last session was properly closed
	 */
	public static void setClosedProperly(boolean closedProperly) {
		FilePEASetting.closedProperly = closedProperly;
	}
}
