package cologne.eck.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;

//import cologne.eck.calendar_pea.data.PEvent;

/*
 * Peafactory - Production of Password Encryption Archives
 * Copyright (C) 2015  Axel von dem Bruch
 * 
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details.
 * See:  http://www.gnu.org/licenses/gpl-2.0.html
 * You should have received a copy of the GNU General Public License 
 * along with this library.
 */


public class Help {

	

	public final static void printBytes (String comment, byte[] input) {
		System.out.println("\n" + comment + ": ");
		for (int i = 0; i<input.length; i++) {
			if (i > 0 &&i % 32 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	public final static void printBytes (String comment, byte[] input, int begin, int end) {
		System.out.println("\n" + comment + ": "+begin+"-"+end);
		for (int i = begin; i<end; i++) {
			if (i > 0 &&i % 32 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	public final static void printlastBytes (String comment, byte[] input) {
		System.out.println("\n" + comment);
		for (int i = input.length - 32; i<input.length; i++) {
			if (i > 0 &&i % 32 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	public final static void printlastBytes (String comment, byte[] input, int length) {
		System.out.println("\n" + comment);
		for (int i = input.length - length; i<input.length; i++) {
			if (i > 0 &&i % 32 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	public final static void printfirstBytes (String comment, byte[] input) {
		System.out.println("\n" + comment);
		for (int i = 0; i<32; i++) {
			if (i > 0 &&i % 32 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	
	public final static void printInts (String comment, int[] input) {
		System.out.println("\n" + comment + ": ");
		for (int i = 0; i<input.length; i++) {
			if (i > 0 && i % 16 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	
	public final static void printLongs (String comment, long[] input) {
		System.out.println("\n" + comment + ": ");
		for (int i = 0; i<input.length; i++) {
			if (i > 0 && i % 16 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	public final static void printLongs (String comment, long[] input, int begin, int end) {
		System.out.println("\n" + comment + ": ");
		for (int i = begin; i<end; i++) {
			if (i > 0 && i % 16 == 0) System.out.println("");
			System.out.print(" " + input[i]);			
		}
		System.out.println("");
	}
	
	public final static void printStringArray(String comment, String[] input) {
		System.out.println("\n" + comment + ": ");
		if (input == null) return;
		for (int i = 0; i<input.length; i++) {
			System.out.println(input[i]);			
		}
		System.out.println("");
	}
	public final static void printFileArray(String comment, File[] input) {
		System.out.println("\n" + comment + ": ");
		if (input == null) return;
		for (int i = 0; i<input.length; i++) {
			System.out.println(input[i].getAbsolutePath());			
		}
		System.out.println("");
	}
	public final static void printStringList(String comment, ArrayList<String> list) {
		System.out.println("\n" + comment + ": ");
		int len = list.size();
		for (int i = 0; i < len; i++){
			System.out.println(list.get(i));
		}		
	}

	public final static void printTreeMapKeys(String comment, TreeMap <File, String> map) {
		if (map == null) return;
		Set<File> col = map.keySet();
		File[] keys = col.toArray(new File [0]);
		System.out.println("\n" + comment + ": ");
		for (int i = 0; i < keys.length; i++) {
			System.out.println(keys[i].getAbsolutePath());			
		}
		System.out.println("");
	}
	
	/**
	 * Print stack trace. 
	 * This will write the class name, method name and line number along
	 * with the message to the standard output.
	 * 
	 * @param c			the class (X.class)
	 * @param message	the message
	 * @param lineNumber	the number of lines from stack to print
	 * @param allClasses	true: not only eck elements but all classes are printed 
	 * 						false: only cologne.eck elements are printed
	 */
	public static final void printStack(Class<?> c, String message, int lineNumber, boolean allClasses) {

			System.out.print(c.getSimpleName());
			StackTraceElement[] ste = Thread.currentThread().getStackTrace();
			System.out.print("." + ste[2].getMethodName());
			System.out.print(" " + ste[2].getLineNumber() + ": ");
			System.out.println(message);
			
			//StackTraceElement[] stack = Thread.currentThread().getStackTrace();
    		int stackLen = ste.length;
    		int lineCounter = 0;
    		for (int i = 0; i < stackLen; i++) {
    			if (i == 0) { // always add first line
    				System.out.println("\tat " + ste[i]);
    			}
    			if (allClasses == false) {
    				if ( ste[i].getClassName().startsWith("cologne.eck")) {
    					System.out.println("\tat " + ste[i]);
    					lineCounter++;
    				}
    			} else {
    				System.out.println("\tat " + ste[i]);
					lineCounter++;
    			}
    			if (lineCounter > lineNumber) {
    				break;
    			}
    		}
	}
}
